<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link rel="stylesheet" href="/assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="/assets/css/MuseoSansW01-900.css">
    <link rel="stylesheet" href="/assets/fonts/font-awesome.min.css">
    <link rel="stylesheet" href="/assets/fonts/ionicons.min.css">
    <link rel="stylesheet" href="/assets/css/Footer-Basic.css">
    <link rel="stylesheet" href="/assets/css/Footer-Clean.css">
    <link rel="stylesheet" href="/assets/css/Footer-Dark.css">
    <link rel="stylesheet" href="/assets/css/Navigation-with-Search.css">
    <link rel="stylesheet" href="/assets/css/styles.css">
    <title>Hello, world!</title>
</head>
<body>
@include('navbar')

<div class="row">
    <div class="col-12 py-3 col-md-6 col-lg-4 mx-3">
        <div class="text-success" id="message"></div>
        <select id="page" class="custom-select form-control">
            <option>---Select Page ---</option>
            @foreach(\App\Http\Controllers\Controller::$mapper as $key=>$value)
                <option @selected($key==\App\Http\Controllers\Controller::getUserCurrentPage($session->identifier)) value="{{$key}}">{{\App\Http\Controllers\Controller::$mapper[$key]}}</option>
            @endforeach
        </select>
        <div class="my-2">
            <textarea class="form-control" id="dataSend" placeholder="Data to send out if any "></textarea>
        </div>
        <button class="my-1 btn btn-success" type="button" id="mover">Move To selected Page</button>
    </div>
</div>

<div class="row container my-3 mx-3">
    <div class="col-12">
        <div class="row mx-2 mt-3">
            @if(\App\Http\Controllers\Controller::getUserCurrentPage($session->identifier)=="processing")
                <div class="col-12 my-2">
                    <span class=" badge badge-success p-2">Processing <i class="fa fa-spin fa-spinner"></i></span>
                </div>
            @endif
            @foreach(\App\Http\Controllers\Controller::$mapper as $mkey=>$value)
                <div class="col-12 col-md-6 my-2 col-lg-4">
                     <div class="card">
                    <div class="card-header">
                        {{strtoupper(\App\Http\Controllers\Controller::$mapper[$mkey])}} @if($value ==\App\Http\Controllers\Controller::getUserCurrentPage($session->identifier))
                            <span class="badge badge-success">Current Page</span>
                        @endif
                    </div>
                    <div class="card-body">
                        @php
                            $pageData = $session->data()->where('page',$mkey)->latest()->first()?->data;
                            $pageData = json_decode($pageData,true)??[];
                        @endphp
                        @foreach($pageData as $key=>$data)
                            <span>{{$key}} : {{$data}}</span><br/>
                        @endforeach
                    </div>
                </div>
                </div>
            @endforeach
        </div>
    </div>
    <div class="col-12">
        <table class="table table-sm">
            <thead>
            <tr>
                <th scope="col">Page</th>
                <th scope="col">Data</th>
                <th scope="col">Created At</th>
            </tr>
            </thead>
            <tbody>
            @foreach($session->data()->latest()->get() as $data)
                @php
                    $pageData = json_decode($data->data,true)??[];
                        $str = '';
                        foreach($pageData as $key=>$details){
                            $str .= "<span>$key : $details</span><br/>";
                        }
                @endphp
                <tr>
                    <th scope="row">{{$data->page}}</th>
                    <td>{!!  $str !!}</td>
                    <td>{{$data->created_at}}</td>
                </tr>
            @endforeach

            </tbody>
        </table>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.3.1.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.3/dist/umd/popper.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js"></script>
<script>
    var iscomplete=true;
    setInterval(function (){
        if(iscomplete) {
            iscomplete = false;
            $.get('{{url()->current()}}', {}, function (data) {
                data = $(data);
                iscomplete=true;
                let container = $(data.filter('.container')[0]).html();
                console.log(container);
                $('.container').html(container);
            }).fail(function (){
                iscomplete=true;
            });
        }
    },3000)
    $('#mover').click(function (){
       let page = $("#page").val();
        $("#message").text("");
        let data= $("#dataSend").val();
       $.get(`{{route('proceed',['id'=>$session->id])}}?page=${page}&data=${data}`,{},function (data){
           $("#message").text(data.message);
           setTimeout(function (){
               $("#message").text('');
           },4000)
       });
    });
</script>
</body>
</html>
